/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.gui;

import betteradvancements.advancements.BetterDisplayInfo;
import betteradvancements.advancements.BetterDisplayInfoRegistry;
import betteradvancements.gui.BetterAdvancementTabType;
import betteradvancements.gui.BetterAdvancementWidget;
import betteradvancements.gui.BetterAdvancementsScreen;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1060;
import net.minecraft.class_161;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_918;

public class BetterAdvancementTab
extends class_332 {
    public static boolean doFade = true;
    public static final Map<class_161, class_3545<Integer, Integer>> scrollHistory = Maps.newLinkedHashMap();
    private final class_310 minecraft;
    private final BetterAdvancementsScreen screen;
    private final BetterAdvancementTabType type;
    private final int index;
    private final class_161 advancement;
    private final class_185 display;
    private final class_1799 icon;
    private final class_2561 title;
    private final BetterAdvancementWidget root;
    protected final Map<class_161, BetterAdvancementWidget> guis = Maps.newLinkedHashMap();
    private final BetterDisplayInfoRegistry betterDisplayInfos;
    protected int scrollX;
    protected int scrollY;
    private int minX = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private float fade;
    private boolean centered;

    public BetterAdvancementTab(class_310 mc, BetterAdvancementsScreen betterAdvancementsScreen, BetterAdvancementTabType type, int index, class_161 advancement, class_185 displayInfo) {
        this.minecraft = mc;
        this.screen = betterAdvancementsScreen;
        this.type = type;
        this.index = index;
        this.advancement = advancement;
        this.display = displayInfo;
        this.icon = displayInfo.method_821();
        this.title = displayInfo.method_811();
        this.betterDisplayInfos = new BetterDisplayInfoRegistry(advancement);
        this.root = new BetterAdvancementWidget(this, mc, advancement, displayInfo);
        this.addGuiAdvancement(this.root, advancement);
    }

    public class_161 getAdvancement() {
        return this.advancement;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public void drawTab(class_4587 poseStack, int left, int top, int width, int height, boolean selected) {
        this.type.draw(this, poseStack, left, top, width, height, selected, this.index);
    }

    public void drawIcon(class_4587 poseStack, int left, int top, int width, int height, class_918 renderItem) {
        this.type.drawIcon(poseStack, left, top, width, height, this.index, renderItem, this.icon);
    }

    public void drawContents(class_4587 poseStack, int width, int height) {
        if (!this.centered) {
            this.scrollX = (width - (this.maxX + this.minX)) / 2;
            this.scrollY = (height - (this.maxY + this.minY)) / 2;
            this.centered = true;
        }
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, 950.0);
        RenderSystem.enableDepthTest();
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        BetterAdvancementTab.method_25294((class_4587)poseStack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        poseStack.method_22904(0.0, 0.0, -950.0);
        RenderSystem.depthFunc((int)518);
        BetterAdvancementTab.method_25294((class_4587)poseStack, (int)width, (int)height, (int)0, (int)0, (int)-16777216);
        RenderSystem.depthFunc((int)515);
        class_2960 resourcelocation = this.display.method_812();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)(resourcelocation != null ? resourcelocation : class_1060.field_5285));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.scrollX % 16;
        int j = this.scrollY % 16;
        for (int k = -1; k <= 1 + width / 16; ++k) {
            int l;
            for (l = -1; l <= height / 16; ++l) {
                BetterAdvancementTab.method_25290((class_4587)poseStack, (int)(i + 16 * k), (int)(j + 16 * l), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
            BetterAdvancementTab.method_25290((class_4587)poseStack, (int)(i + 16 * k), (int)(j + 16 * l), (float)0.0f, (float)0.0f, (int)16, (int)(height % 16), (int)16, (int)16);
        }
        this.root.drawConnectivity(poseStack, this.scrollX, this.scrollY, true);
        this.root.drawConnectivity(poseStack, this.scrollX, this.scrollY, false);
        this.root.draw(poseStack, this.scrollX, this.scrollY);
        RenderSystem.depthFunc((int)518);
        poseStack.method_22904(0.0, 0.0, -950.0);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        BetterAdvancementTab.method_25294((class_4587)poseStack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthFunc((int)515);
        poseStack.method_22909();
    }

    public void drawToolTips(class_4587 poseStack, int mouseX, int mouseY, int left, int top, int width, int height) {
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, -200.0);
        BetterAdvancementTab.method_25294((class_4587)poseStack, (int)0, (int)0, (int)width, (int)height, (int)(class_3532.method_15375((float)(this.fade * 255.0f)) << 24));
        boolean flag = false;
        if (mouseX > 0 && mouseX < width && mouseY > 0 && mouseY < height) {
            for (BetterAdvancementWidget betterAdvancementWidget : this.guis.values()) {
                if (!betterAdvancementWidget.isMouseOver(this.scrollX, this.scrollY, mouseX, mouseY)) continue;
                flag = true;
                betterAdvancementWidget.drawHover(poseStack, this.scrollX, this.scrollY, this.fade, left, top);
                break;
            }
        }
        poseStack.method_22909();
        this.fade = doFade && flag ? class_3532.method_15363((float)(this.fade + 0.02f), (float)0.0f, (float)0.3f) : class_3532.method_15363((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
    }

    public boolean isMouseOver(int left, int top, int width, int height, double mouseX, double mouseY) {
        return this.type.isMouseOver(left, top, width, height, this.index, mouseX, mouseY);
    }

    @Nullable
    public static BetterAdvancementTab create(class_310 mc, BetterAdvancementsScreen betterAdvancementsScreen, int index, class_161 advancement, int width, int height) {
        if (advancement.method_686() == null) {
            return null;
        }
        BetterAdvancementTabType advancementTabType = BetterAdvancementTabType.getTabType(width, height, index);
        if (advancementTabType == null) {
            return null;
        }
        return new BetterAdvancementTab(mc, betterAdvancementsScreen, advancementTabType, index, advancement, advancement.method_686());
    }

    public void scroll(double scrollX, double scrollY, int width, int height) {
        if (this.maxX - this.minX > width) {
            this.scrollX = (int)Math.round(class_3532.method_15350((double)((double)this.scrollX + scrollX), (double)(-(this.maxX - width)), (double)(-this.minX)));
        }
        if (this.maxY - this.minY > height) {
            this.scrollY = (int)Math.round(class_3532.method_15350((double)((double)this.scrollY + scrollY), (double)(-(this.maxY - height)), (double)(-this.minY)));
        }
    }

    public void addAdvancement(class_161 advancement) {
        if (advancement.method_686() != null) {
            BetterAdvancementWidget betterAdvancementEntryScreen = new BetterAdvancementWidget(this, this.minecraft, advancement, advancement.method_686());
            this.addGuiAdvancement(betterAdvancementEntryScreen, advancement);
        }
    }

    private void addGuiAdvancement(BetterAdvancementWidget betterAdvancementEntryScreen, class_161 advancement) {
        this.guis.put(advancement, betterAdvancementEntryScreen);
        int left = betterAdvancementEntryScreen.getX();
        int right = left + 28;
        int top = betterAdvancementEntryScreen.getY();
        int bottom = top + 27;
        this.minX = Math.min(this.minX, left);
        this.maxX = Math.max(this.maxX, right);
        this.minY = Math.min(this.minY, top);
        this.maxY = Math.max(this.maxY, bottom);
        for (BetterAdvancementWidget gui : this.guis.values()) {
            gui.attachToParent();
        }
    }

    @Nullable
    public BetterAdvancementWidget getWidget(class_161 advancement) {
        return this.guis.get(advancement);
    }

    public BetterAdvancementsScreen getScreen() {
        return this.screen;
    }

    public BetterDisplayInfo getBetterDisplayInfo(class_161 advancement) {
        return this.betterDisplayInfos.get(advancement);
    }

    public void storeScroll() {
        scrollHistory.put(this.advancement, (class_3545<Integer, Integer>)new class_3545((Object)this.scrollX, (Object)this.scrollY));
    }

    public void loadScroll() {
        class_3545<Integer, Integer> scroll = scrollHistory.get(this.advancement);
        if (scroll != null) {
            this.centered = true;
            this.scrollX = (Integer)scroll.method_15442();
            this.scrollY = (Integer)scroll.method_15441();
        }
    }
}

